!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!
module cubemain_stack_spectra_tool
  use cubetools_parameters
  use cubesyntax_key_types
  use cubemain_messaging
  !
  public :: contaminate,signal,background
  public :: stack_spectra_comm_t,stack_spectra_user_t,stack_spectra_prog_t
  private
  !
  logical, parameter :: contaminate = .true.
  real(kind=sign_k), parameter :: signal     = 1.0
  real(kind=sign_k), parameter :: background = 2.0
  !
  type stack_spectra_comm_t
     type(key_comm_t), private :: sum
     type(key_comm_t), private :: mean
   contains
     procedure, public :: register => stack_spectra_comm_register
     procedure, public :: parse    => stack_spectra_comm_parse
  end type stack_spectra_comm_t
  !
  type stack_spectra_user_t
     type(key_user_t), private :: sum
     type(key_user_t), private :: mean
   contains
     procedure, public :: toprog => stack_spectra_user_toprog
  end type stack_spectra_user_t
  !
  type stack_spectra_prog_t
     real(kind=sign_k), private :: factor = 0.0          ! Brightness multiplicative factor
     logical,           private :: mean = .true.         ! Mean or Sum?
     logical,           private :: contaminate = .false. ! NaNs contaminate spectrum
   contains
     procedure :: list         => cubemain_stack_spectra_prog_list
     procedure :: set_unit     => cubemain_stack_spectra_prog_set_unit
     procedure :: without_mask => cubemain_stack_spectra_prog_act_without_mask
     procedure :: with_mask    => cubemain_stack_spectra_prog_act_with_mask
     procedure :: backsubtract => cubemain_stack_spectra_prog_act_with_backsubtraction
  end type stack_spectra_prog_t
  !
contains
  !
  subroutine stack_spectra_comm_register(comm,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_comm_t), intent(inout) :: comm
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='STACK>SPECTRA>COMM>REGISTER'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call comm%sum%register('SUM','A sum will be computed',error)
    if (error) return
    call comm%mean%register('MEAN','A mean will be computed',error)
    if (error) return
  end subroutine stack_spectra_comm_register
  !
  subroutine stack_spectra_comm_parse(comm,line,user,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_comm_t), intent(in)    :: comm
    character(len=*),            intent(in)    :: line
    type(stack_spectra_user_t),  intent(inout) :: user
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='STACK>SPECTRA>COMM>PARSE'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call comm%sum%parse(line,user%sum,error)
    if (error) return
    call comm%mean%parse(line,user%sum,error)
    if (error) return
  end subroutine stack_spectra_comm_parse
  !
  !------------------------------------------------------------------------
  !
  subroutine stack_spectra_user_toprog(user,cube,prog,error)
    use cube_types
    use cubetools_header_methods
    use cubetools_brightness
    !----------------------------------------------------------------------
    ! /SUM and /MEAN are mutually exclusive
    !----------------------------------------------------------------------
    class(stack_spectra_user_t), intent(in)    :: user
    type(cube_t),                intent(in)    :: cube
    type(stack_spectra_prog_t),  intent(inout) :: prog
    logical,                     intent(inout) :: error
    !
    logical :: known_brightness
    integer(kind=code_k) :: code
    character(len=unit_l) :: unit
    character(len=*), parameter :: rname='STACK>SPECTRA>USER>TOPROG'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    if (user%sum%present.and.user%mean%present)then
       call cubemain_message(seve%e,rname,'Options /MEAN and /SUM are mutually exclusive')
       error = .true.
       return
    else if (user%sum%present) then
       prog%mean = .false.
    else if (user%mean%present) then
       prog%mean = .true.
    else
       ! Default behavior depends on cube unit
       call cubetools_header_get_array_unit(cube%head,unit,error)
       if (error) return
       call cubetools_brightness_valid_brightness_unit(unit,code,known_brightness,error)
       if (error) return
       if (known_brightness) then
          select case(code)
          case (code_unit_jyperbeam,code_unit_jyperpixel,code_unit_mjypersr)
             prog%mean = .false.
          case (code_unit_tmb)
             prog%mean = .true.
          case (code_unit_tas)
             call cubemain_message(seve%e,rname,'Tas unit => Convert it to Tmb first with CUBE\CONVERT')
             error = .true.
             return
          case default
             call cubemain_message(seve%w,rname,'Unknown brightness unit'//trim(unit))
             call cubemain_message(seve%w,rname,'Default to averaging'//trim(unit))
             prog%mean = .true.
          end select
       else
          call cubemain_message(seve%w,rname,'Default to averaging for unit '//trim(unit))
          prog%mean = .true.
       endif
    endif       
    !
!!$    if (domask) then
!!$       prog%loop => cubemain_stack_spectra_loop_mask
!!$    else       
!!$       prog%loop => cubemain_stack_spectra_loop_nomask
!!$    endif
  end subroutine stack_spectra_user_toprog
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_stack_spectra_prog_set_unit(prog,stacked,error)
    use cube_types
    use cubetools_header_methods
    use cubetools_brightness
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_prog_t), intent(inout) :: prog
    type(cube_t),                intent(inout) :: stacked
    logical,                     intent(inout) :: error
    !
    logical :: known_brightness
    integer(kind=code_k) :: code
    character(len=unit_l) :: unit
    real(kind=sign_k), parameter :: feff=1.0
    real(kind=sign_k), parameter :: beff=1.0
    character(len=*), parameter :: rname='STACK>SPECTRA>PROG>SET>UNIT'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    call cubetools_header_get_array_unit(stacked%head,unit,error)
    if (error) return
    call cubetools_brightness_valid_brightness_unit(unit,code,known_brightness,error)
    if (error) return
    if (known_brightness) then
       if (prog%mean) then
          call cubetools_header_brightness2brightness(stacked%head,&
               .not.applyeff,feff,beff,code_unit_tmb,prog%factor,error)
          if (error) return
          unit = brightness_get(code_unit_tmb)
       else
          call cubetools_header_brightness2flux(stacked%head,code_unit_jy,prog%factor,error)
          if (error) return
          unit = flux_get(code_unit_jy)
       endif
       call cubetools_header_put_array_unit(unit,stacked%head,error)
       if (error) return
    else
       ! Unit stays unchanged
       prog%factor = 1
    endif
  end subroutine cubemain_stack_spectra_prog_set_unit
  !
  !------------------------------------------------------------------------
  !
  subroutine cubemain_stack_spectra_prog_list(prog,error)
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_prog_t), intent(in)    :: prog
    logical,                     intent(inout) :: error
    !
    character(len=*), parameter :: rname='STACK>SPECTRA>PROG>LIST'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    print *,'Mean: ',prog%mean
    print *,'Contaminate: ',prog%contaminate
  end subroutine cubemain_stack_spectra_prog_list
  !
  subroutine cubemain_stack_spectra_prog_act_without_mask(prog,image,weight,stacked,error)
    use cubetools_nan
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_prog_t), intent(in)    :: prog
    type(image_t),               intent(in)    :: image
    type(image_t),               intent(in)    :: weight
    type(image_t),               intent(inout) :: stacked
    logical,                     intent(inout) :: error
    !
    integer(kind=pixe_k), parameter :: one = 1
    integer(kind=pixe_k) :: ix,iy
    real(kind=sign_k) :: val,wei
    character(len=*), parameter :: rname='STACK>SPECTRA>PROG>ACT>WITHOUT>MASK'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    val = 0
    wei = 0
    if (prog%contaminate) then
       do iy=1,image%ny
          do ix=1,image%nx
             val = val + image%val(ix,iy)*weight%val(ix,iy)
             wei = wei + weight%val(ix,iy)
          enddo ! ix
       enddo ! iy
    else
       do iy=1,image%ny
          do ix=1,image%nx
             if (ieee_is_nan(image%val(ix,iy)).or.ieee_is_nan(weight%val(ix,iy))) cycle
             val = val + image%val(ix,iy)*weight%val(ix,iy)
             wei = wei + weight%val(ix,iy)
          enddo ! ix
       enddo ! iy
    endif
    if (wei.gt.0) then
       stacked%val(one,one) = val/wei*prog%factor
    else
       stacked%val(one,one) = gr4nan
    endif
  end subroutine cubemain_stack_spectra_prog_act_without_mask
  !
  subroutine cubemain_stack_spectra_prog_act_with_mask(prog,image,mask,weight,stacked,error)
    use cubetools_nan
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_prog_t), intent(in)    :: prog
    type(image_t),               intent(in)    :: image
    type(image_t),               intent(in)    :: mask
    type(image_t),               intent(in)    :: weight
    type(image_t),               intent(inout) :: stacked
    logical,                     intent(inout) :: error
    !
    integer(kind=pixe_k), parameter :: one = 1
    integer(kind=pixe_k) :: ix,iy
    real(kind=sign_k) :: val,wei
    character(len=*), parameter :: rname='STACK>SPECTRA>PROG>ACT>WITH>MASK'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    val = 0
    wei = 0
    if (prog%contaminate) then
       do iy=1,image%ny
          do ix=1,image%nx
             if (ieee_is_nan(mask%val(ix,iy))) cycle
             val = val + image%val(ix,iy)*weight%val(ix,iy)
             wei = wei + weight%val(ix,iy)
          enddo ! ix
       enddo ! iy
    else
       do iy=1,image%ny
          do ix=1,image%nx
             if ((ieee_is_nan(image%val(ix,iy))).or.&
                  (ieee_is_nan(weight%val(ix,iy))).or.&
                  (ieee_is_nan(mask%val(ix,iy)))) cycle
             val = val + image%val(ix,iy)*weight%val(ix,iy)
             wei = wei + weight%val(ix,iy)
          enddo ! ix
       enddo ! iy
    endif
    if (wei.gt.0) then
       stacked%val(one,one) = val/wei*prog%factor
    else
       stacked%val(one,one) = gr4nan
    endif
  end subroutine cubemain_stack_spectra_prog_act_with_mask
  !
  subroutine cubemain_stack_spectra_prog_act_with_backsubtraction(prog,image,weight,mask,stacked,error)
    use cubetools_nan
    use cubeadm_image_types
    !----------------------------------------------------------------------
    !
    !----------------------------------------------------------------------
    class(stack_spectra_prog_t), intent(in)    :: prog
    type(image_t),               intent(in)    :: image
    type(image_t),               intent(in)    :: weight
    type(image_t),               intent(in)    :: mask
    type(image_t),               intent(inout) :: stacked
    logical,                     intent(inout) :: error
    !
    integer(kind=pixe_k) :: ix,iy
    integer(kind=pixe_k), parameter :: one = 1
    real(kind=sign_k) :: signval,signwei
    real(kind=sign_k) :: backval,backwei
    character(len=*), parameter :: rname='STACK>SPECTRA>PROG>ACT>WITH>BACKSUBTRACTION'
    !
    call cubemain_message(mainseve%trace,rname,'Welcome')
    !
    signval = 0
    signwei = 0
    backval = 0
    backwei = 0
    if (prog%contaminate) then
       do iy=1,image%ny
          do ix=1,image%nx
             if (ieee_is_nan(mask%val(ix,iy))) cycle
             if (mask%val(ix,iy).eq.signal) then
                signval = signval + image%val(ix,iy)*weight%val(ix,iy)
                signwei = signwei + weight%val(ix,iy)
             else if (mask%val(ix,iy).eq.background) then
                backval = backval + image%val(ix,iy)*weight%val(ix,iy)
                backwei = backwei + weight%val(ix,iy)
             else
                call cubemain_message(mainseve%trace,rname,'Unknown mask value (nor signal, nor background, nor NaN)')
                error = .true.
                return
             endif
          enddo ! ix
       enddo ! iy
    else
       do iy=1,image%ny
          do ix=1,image%nx
             if ((ieee_is_nan(image%val(ix,iy))).or.&
                  (ieee_is_nan(weight%val(ix,iy))).or.&
                  (ieee_is_nan(mask%val(ix,iy)))) cycle
             if (mask%val(ix,iy).eq.signal) then
                signval = signval + image%val(ix,iy)*weight%val(ix,iy)
                signwei = signwei + weight%val(ix,iy)
             else if (mask%val(ix,iy).eq.background) then
                backval = backval + image%val(ix,iy)*weight%val(ix,iy)
                backwei = backwei + weight%val(ix,iy)
             else
                call cubemain_message(mainseve%trace,rname,'Unknown mask value (nor signal, nor background, nor NaN)')
                error = .true.
                return
             endif
          enddo ! ix
       enddo ! iy
    endif
    if (signwei.gt.0) then
       if (backwei.gt.0) then
          stacked%val(one,one) = signval/signwei*prog%factor
       else if (backwei.eq.0) then
          stacked%val(one,one) = (signval/signwei - backval/backwei)*prog%factor
       else
          stacked%val(one,one) = gr4nan
       endif
    else
       stacked%val(one,one) = gr4nan
    endif
  end subroutine cubemain_stack_spectra_prog_act_with_backsubtraction
end module cubemain_stack_spectra_tool
!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
