# GILDAS graphic interface

## Structure

```sh  
ggtk
├── gtk-dialog.c        # 
├── gtk-dialog.h        # 
├── gtk-graph.c         # 
├── gtk-graph.h         # 
├── gtk-local.h         # 
├── gtk-main.c          # 
├── gtk-menu.c          # 
├── gtk-menu.h          # 
├── gtk-toolbar.c       # 
├── gtk-toolbar.h       # 
├── magnify-tool.c      # 
├── magnify-tool.h      # 
├── message-c.c         # 
├── message-c.h         # 
├── zoom-tool.c         # 
├── zoom-tool.h         # 
├── Makefile            # 
└── win-ggtk.def        # 
```

## Main concepts

The graphic interface is handled by C code files located under ggtk2 or ggtk3 directories.

The ggtk library exposes a list of methods which can be called by the main code principally written in fortran.  

The fortran code, run in the main thread, calls methods exposed by the ggtk library if this library is built.

The ggtk code is run in a dedicated thread.

When graphic elements are created (polylines, surfaces etc...) the main thread calls specific methods implemented by the ggtk library to draw those elements in a gtk drawing area (if any)

## Legacy graphic interface using GTK2

The ggtk library based on GTK2 is located in ggtk2 folder (next to the ggtk folder) and works as follow:
- Creation of the new thread
- Initialization of the GTK windows to build
- Call of the gkt main loop function which displays the different windows
- When a graphical component (like a polyline) is created by the main thread, a specific API is called on ggtk side to draw this element inside the active drawing area (the environment in which the graphical element needs to be displayed is passed as an argument to the draw method)

Note here that the rendering operations are synchronously executed when the main thread code calls the dedicated ggtk draw APIs.

GTK2 library is deprecated and should not be used anymore.
To build the GILDAS graphical interface using GTK2, source your environment as follow:

```sh
. admin/gildas-env.sh -o gtk2
```

## Current graphic interface based on GTK3

The ggtk library based on GTK3 works almost similarly as GTK2 for the panel creation and for the main loop process. The way elements are rendered is changed and works now with Cairo:
- Creation of the new thread
- Initialization of the GTK windows to build
- Call of the gkt main loop function which displays the different windows
- When a graphical component (like a polyline) is created by the main thread, a specific API is called on ggtk side to store this element in a buffer attached to the current graphical environment (main drawing area or the magnifying tool basically). GTK uses a draw event which basically asks to render the entire screen in one shot. This process, based on events, is asynchronous. When the draw callback is executed, the internal graphical element stores are used to render the view.

Note here that the rendering operations are asynchronously executed. GTK manages his own way to redraw the drawing area.
In the code we can ask for a redraw but this operation is not synchronous. It just warns GTK that a refresh of the drawing area is required.

To build the GILDAS graphical interface using GTK3, source your environment as follow:

```sh
. admin/gildas-env.sh
```

## Next steps: GTK4

